#include "meeting_sdk_impl.h"
#include <assert.h>

typedef JMResult (*PFEventCallbackSet)(const char *pEventName, void *pfFuncCallBack);
typedef JMResult (*PFFunctionGet)(const char *pFunctionName, void **pfFunc);


/***
*	IDSMgrImpl
***/
IDSMgrImpl::IDSMgrImpl()
{
	mpfsetDSEvent = NULL;
	mpfisInDS = NULL;
	mpfisSharingInDS = NULL;
	mpfcanStartDS = NULL;
	mpfcanJoinDS = NULL;
	mpfstartDS = NULL;
	mpfjoinDS = NULL;
	mpfdeclineDSInvitation = NULL;
	mpfinviteUser2DS = NULL;
	mpfendDS = NULL;
	mpfreSharing = NULL;
	mpfchangePresenter = NULL;
	mpfreceiveDSInvitation = NULL;
	mpfreceiveDSDecline = NULL;
	mpfreceiveDSCancelled = NULL;
}

IDSMgrImpl::~IDSMgrImpl()
{
}

void IDSMgrImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_setDSEvent, (void**)&mpfsetDSEvent);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_isInDS, (void**)&mpfisInDS);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_isSharingInDS, (void**)&mpfisSharingInDS);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_canStartDS, (void**)&mpfcanStartDS);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_canJoinDS, (void**)&mpfcanJoinDS);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_startDS, (void**)&mpfstartDS);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_joinDS, (void**)&mpfjoinDS);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_declineDSInvitation, (void**)&mpfdeclineDSInvitation);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_inviteUser2DS, (void**)&mpfinviteUser2DS);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_endDS, (void**)&mpfendDS);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_reSharing, (void**)&mpfreSharing);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_changePresenter, (void**)&mpfchangePresenter);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_receiveDSInvitation, (void**)&mpfreceiveDSInvitation);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_receiveDSDecline, (void**)&mpfreceiveDSDecline);
	jmResult = (*pfFunctionGet)(JMSDK_IDSMgr_receiveDSCancelled, (void**)&mpfreceiveDSCancelled);
}

void IDSMgrImpl::FuncUnInit()
{
	mpfsetDSEvent = NULL;
	mpfisInDS = NULL;
	mpfisSharingInDS = NULL;
	mpfcanStartDS = NULL;
	mpfcanJoinDS = NULL;
	mpfstartDS = NULL;
	mpfjoinDS = NULL;
	mpfdeclineDSInvitation = NULL;
	mpfinviteUser2DS = NULL;
	mpfendDS = NULL;
	mpfreSharing = NULL;
	mpfchangePresenter = NULL;
	mpfreceiveDSInvitation = NULL;
	mpfreceiveDSDecline = NULL;
	mpfreceiveDSCancelled = NULL;
}

void IDSMgrImpl::setDSEvent(IDSEvent* pEvent)
{
	JMResult jmResult = (*mpfsetDSEvent)(pEvent);
	assert(jmResult == JMSucceed);
}

bool IDSMgrImpl::isInDS()
{
	bool ret;
	JMResult jmResult = (*mpfisInDS)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IDSMgrImpl::isSharingInDS()
{
	bool ret;
	JMResult jmResult = (*mpfisSharingInDS)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IDSMgrImpl::canStartDS(const PString sessionName)
{
	bool ret;
	JMResult jmResult = (*mpfcanStartDS)(sessionName, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IDSMgrImpl::canJoinDS(const PString sessionName)
{
	bool ret;
	JMResult jmResult = (*mpfcanJoinDS)(sessionName, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

void IDSMgrImpl::startDS(const PString sessionName, const PString serverUrl, const PString token)
{
	JMResult jmResult = (*mpfstartDS)(sessionName, serverUrl, token);
	assert(jmResult == JMSucceed);
}

void IDSMgrImpl::joinDS(const PString sessionName)
{
	JMResult jmResult = (*mpfjoinDS)(sessionName);
	assert(jmResult == JMSucceed);
}

void IDSMgrImpl::declineDSInvitation(const PString sessionName)
{
	JMResult jmResult = (*mpfdeclineDSInvitation)(sessionName);
	assert(jmResult == JMSucceed);
}

void IDSMgrImpl::inviteUser2DS(const PString sessionName)
{
	JMResult jmResult = (*mpfinviteUser2DS)(sessionName);
	assert(jmResult == JMSucceed);
}

void IDSMgrImpl::endDS()
{
	JMResult jmResult = (*mpfendDS)();
	assert(jmResult == JMSucceed);
}

void IDSMgrImpl::reSharing()
{
	JMResult jmResult = (*mpfreSharing)();
	assert(jmResult == JMSucceed);
}

void IDSMgrImpl::changePresenter()
{
	JMResult jmResult = (*mpfchangePresenter)();
	assert(jmResult == JMSucceed);
}

void IDSMgrImpl::receiveDSInvitation(const PString sessionName, const PString cmdMsg)
{
	JMResult jmResult = (*mpfreceiveDSInvitation)(sessionName, cmdMsg);
	assert(jmResult == JMSucceed);
}

void IDSMgrImpl::receiveDSDecline(const PString sessionName)
{
	JMResult jmResult = (*mpfreceiveDSDecline)(sessionName);
	assert(jmResult == JMSucceed);
}

void IDSMgrImpl::receiveDSCancelled(const PString sessionName)
{
	JMResult jmResult = (*mpfreceiveDSCancelled)(sessionName);
	assert(jmResult == JMSucceed);
}


/***
*	IInstantMeetingMgrImpl
***/
IInstantMeetingMgrImpl::IInstantMeetingMgrImpl()
{
	mpfregisterIMEvent = NULL;
	mpfunregisterIMEvent = NULL;
	mpfisInMeeting = NULL;
	mpfisInSharing = NULL;
	mpfcanStartMeeting = NULL;
	mpfcanJoinMeeting = NULL;
	mpfstart = NULL;
	mpfinvite = NULL;
	mpfjoin = NULL;
	mpfdecline = NULL;
	mpfreceiveMeetingInvitation = NULL;
	mpfreceiveMeetingDeclinedMsg = NULL;
	mpfreceiveMeetingCancelledMsg = NULL;
	mpfisWbxInstantMeeting = NULL;
	mpfstartCmr = NULL;
	mpfjoinCmr = NULL;
}

IInstantMeetingMgrImpl::~IInstantMeetingMgrImpl()
{
}

void IInstantMeetingMgrImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_registerIMEvent, (void**)&mpfregisterIMEvent);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_unregisterIMEvent, (void**)&mpfunregisterIMEvent);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_isInMeeting, (void**)&mpfisInMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_isInSharing, (void**)&mpfisInSharing);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_canStartMeeting, (void**)&mpfcanStartMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_canJoinMeeting, (void**)&mpfcanJoinMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_start, (void**)&mpfstart);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_invite, (void**)&mpfinvite);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_join, (void**)&mpfjoin);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_decline, (void**)&mpfdecline);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_receiveMeetingInvitation, (void**)&mpfreceiveMeetingInvitation);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_receiveMeetingDeclinedMsg, (void**)&mpfreceiveMeetingDeclinedMsg);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_receiveMeetingCancelledMsg, (void**)&mpfreceiveMeetingCancelledMsg);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_isWbxInstantMeeting, (void**)&mpfisWbxInstantMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_startCmr, (void**)&mpfstartCmr);
	jmResult = (*pfFunctionGet)(JMSDK_IInstantMeetingMgr_joinCmr, (void**)&mpfjoinCmr);
}

void IInstantMeetingMgrImpl::FuncUnInit()
{
	mpfregisterIMEvent = NULL;
	mpfunregisterIMEvent = NULL;
	mpfisInMeeting = NULL;
	mpfisInSharing = NULL;
	mpfcanStartMeeting = NULL;
	mpfcanJoinMeeting = NULL;
	mpfstart = NULL;
	mpfinvite = NULL;
	mpfjoin = NULL;
	mpfdecline = NULL;
	mpfreceiveMeetingInvitation = NULL;
	mpfreceiveMeetingDeclinedMsg = NULL;
	mpfreceiveMeetingCancelledMsg = NULL;
	mpfisWbxInstantMeeting = NULL;
	mpfstartCmr = NULL;
	mpfjoinCmr = NULL;
}

void IInstantMeetingMgrImpl::registerIMEvent(IInstantMeetingEvent* pEvent)
{
	JMResult jmResult = (*mpfregisterIMEvent)(pEvent);
	assert(jmResult == JMSucceed);
}

void IInstantMeetingMgrImpl::unregisterIMEvent(IInstantMeetingEvent* pEvent)
{
	JMResult jmResult = (*mpfunregisterIMEvent)(pEvent);
	assert(jmResult == JMSucceed);
}

bool IInstantMeetingMgrImpl::isInMeeting()
{
	bool ret;
	JMResult jmResult = (*mpfisInMeeting)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IInstantMeetingMgrImpl::isInSharing()
{
	bool ret;
	JMResult jmResult = (*mpfisInSharing)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IInstantMeetingMgrImpl::canStartMeeting()
{
	bool ret;
	JMResult jmResult = (*mpfcanStartMeeting)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IInstantMeetingMgrImpl::canJoinMeeting()
{
	bool ret;
	JMResult jmResult = (*mpfcanJoinMeeting)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

void IInstantMeetingMgrImpl::start(const PString meetingName, const PString inviteeList)
{
	JMResult jmResult = (*mpfstart)(meetingName, inviteeList);
	assert(jmResult == JMSucceed);
}

void IInstantMeetingMgrImpl::invite(const PString inviteeList)
{
	JMResult jmResult = (*mpfinvite)(inviteeList);
	assert(jmResult == JMSucceed);
}

void IInstantMeetingMgrImpl::join(const PString sessionName)
{
	JMResult jmResult = (*mpfjoin)(sessionName);
	assert(jmResult == JMSucceed);
}

void IInstantMeetingMgrImpl::decline(const PString sessionName)
{
	JMResult jmResult = (*mpfdecline)(sessionName);
	assert(jmResult == JMSucceed);
}

void IInstantMeetingMgrImpl::receiveMeetingInvitation(const PString sessionName, const PString cmdMsg)
{
	JMResult jmResult = (*mpfreceiveMeetingInvitation)(sessionName, cmdMsg);
	assert(jmResult == JMSucceed);
}

void IInstantMeetingMgrImpl::receiveMeetingDeclinedMsg(const PString sessionName, const PString cmdMsg)
{
	JMResult jmResult = (*mpfreceiveMeetingDeclinedMsg)(sessionName, cmdMsg);
	assert(jmResult == JMSucceed);
}

void IInstantMeetingMgrImpl::receiveMeetingCancelledMsg(const PString sessionName, const PString cmdMsg)
{
	JMResult jmResult = (*mpfreceiveMeetingCancelledMsg)(sessionName, cmdMsg);
	assert(jmResult == JMSucceed);
}

bool IInstantMeetingMgrImpl::isWbxInstantMeeting(const PString meetingKey)
{
	bool ret;
	JMResult jmResult = (*mpfisWbxInstantMeeting)(meetingKey, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

void IInstantMeetingMgrImpl::startCmr(bool launch)
{
	JMResult jmResult = (*mpfstartCmr)(launch);
	assert(jmResult == JMSucceed);
}

void IInstantMeetingMgrImpl::joinCmr(const PString strSiteURL, const PString strMeetingKey, const PString strMTGTK)
{
	JMResult jmResult = (*mpfjoinCmr)(strSiteURL, strMeetingKey, strMTGTK);
	assert(jmResult == JMSucceed);
}


/***
*	IMeetingCalendarImpl
***/
IMeetingCalendarImpl::IMeetingCalendarImpl()
{
	mpfsetMCEvent = NULL;
	mpfsetReminderTime = NULL;
	mpfsetMeetingReminderEnable = NULL;
	mpfinitialize = NULL;
	mpfgetIntegrationCalendarType = NULL;
	mpfisMeetingEnabled = NULL;
	mpfisCalendarEnabled = NULL;
	mpfisMeetingInProgress = NULL;
	mpflistMeeting = NULL;
	mpfrefreshMeeting = NULL;
	mpfgetMeetingDay = NULL;
	mpfgetMeetingList = NULL;
	mpfgetMeetingDetail = NULL;
	mpfviewMeetingById = NULL;
	mpflaunchMeetingById = NULL;
	mpfinvokeSystemTimeChange = NULL;
	mpfsendEmail = NULL;
	mpfreceiveReminder = NULL;
	mpfgetRemindCommandMessage = NULL;
	mpfgetInviteCommandMessage = NULL;
	mpfgetCMRInfo = NULL;
}

IMeetingCalendarImpl::~IMeetingCalendarImpl()
{
}

void IMeetingCalendarImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_setMCEvent, (void**)&mpfsetMCEvent);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_setReminderTime, (void**)&mpfsetReminderTime);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_setMeetingReminderEnable, (void**)&mpfsetMeetingReminderEnable);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_initialize, (void**)&mpfinitialize);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_getIntegrationCalendarType, (void**)&mpfgetIntegrationCalendarType);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_isMeetingEnabled, (void**)&mpfisMeetingEnabled);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_isCalendarEnabled, (void**)&mpfisCalendarEnabled);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_isMeetingInProgress, (void**)&mpfisMeetingInProgress);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_listMeeting, (void**)&mpflistMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_refreshMeeting, (void**)&mpfrefreshMeeting);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_getMeetingDay, (void**)&mpfgetMeetingDay);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_getMeetingList, (void**)&mpfgetMeetingList);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_getMeetingDetail, (void**)&mpfgetMeetingDetail);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_viewMeetingById, (void**)&mpfviewMeetingById);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_launchMeetingById, (void**)&mpflaunchMeetingById);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_invokeSystemTimeChange, (void**)&mpfinvokeSystemTimeChange);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_sendEmail, (void**)&mpfsendEmail);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_receiveReminder, (void**)&mpfreceiveReminder);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_getRemindCommandMessage, (void**)&mpfgetRemindCommandMessage);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_getInviteCommandMessage, (void**)&mpfgetInviteCommandMessage);
	jmResult = (*pfFunctionGet)(JMSDK_IMeetingCalendar_getCMRInfo, (void**)&mpfgetCMRInfo);
}

void IMeetingCalendarImpl::FuncUnInit()
{
	mpfsetMCEvent = NULL;
	mpfsetReminderTime = NULL;
	mpfsetMeetingReminderEnable = NULL;
	mpfinitialize = NULL;
	mpfgetIntegrationCalendarType = NULL;
	mpfisMeetingEnabled = NULL;
	mpfisCalendarEnabled = NULL;
	mpfisMeetingInProgress = NULL;
	mpflistMeeting = NULL;
	mpfrefreshMeeting = NULL;
	mpfgetMeetingDay = NULL;
	mpfgetMeetingList = NULL;
	mpfgetMeetingDetail = NULL;
	mpfviewMeetingById = NULL;
	mpflaunchMeetingById = NULL;
	mpfinvokeSystemTimeChange = NULL;
	mpfsendEmail = NULL;
	mpfreceiveReminder = NULL;
	mpfgetRemindCommandMessage = NULL;
	mpfgetInviteCommandMessage = NULL;
	mpfgetCMRInfo = NULL;
}

void IMeetingCalendarImpl::setMCEvent(IMeetingCalendarEvent* pEvent)
{
	JMResult jmResult = (*mpfsetMCEvent)(pEvent);
	assert(jmResult == JMSucceed);
}

void IMeetingCalendarImpl::setReminderTime(long start, long stop)
{
	JMResult jmResult = (*mpfsetReminderTime)(start, stop);
	assert(jmResult == JMSucceed);
}

void IMeetingCalendarImpl::setMeetingReminderEnable(bool isEnable)
{
	JMResult jmResult = (*mpfsetMeetingReminderEnable)(isEnable);
	assert(jmResult == JMSucceed);
}

void IMeetingCalendarImpl::initialize(CalendarType type)
{
	JMResult jmResult = (*mpfinitialize)(type);
	assert(jmResult == JMSucceed);
}

CalendarType IMeetingCalendarImpl::getIntegrationCalendarType()
{
	CalendarType ret;
	JMResult jmResult = (*mpfgetIntegrationCalendarType)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IMeetingCalendarImpl::isMeetingEnabled()
{
	bool ret;
	JMResult jmResult = (*mpfisMeetingEnabled)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IMeetingCalendarImpl::isCalendarEnabled()
{
	bool ret;
	JMResult jmResult = (*mpfisCalendarEnabled)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IMeetingCalendarImpl::isMeetingInProgress(const PString meetingID)
{
	bool ret;
	JMResult jmResult = (*mpfisMeetingInProgress)(meetingID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

void IMeetingCalendarImpl::listMeeting(MeetingTime mtDay)
{
	JMResult jmResult = (*mpflistMeeting)(mtDay);
	assert(jmResult == JMSucceed);
}

void IMeetingCalendarImpl::refreshMeeting()
{
	JMResult jmResult = (*mpfrefreshMeeting)();
	assert(jmResult == JMSucceed);
}

bool IMeetingCalendarImpl::getMeetingDay(MeetingTime& mtDay)
{
	bool ret;
	JMResult jmResult = (*mpfgetMeetingDay)(mtDay, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IMeetingCalendarImpl::getMeetingList(MeetingList& meetingList)
{
	bool ret;
	JMResult jmResult = (*mpfgetMeetingList)(meetingList, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IMeetingCalendarImpl::getMeetingDetail(const PString meetingID)
{
	bool ret;
	JMResult jmResult = (*mpfgetMeetingDetail)(meetingID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IMeetingCalendarImpl::viewMeetingById(const PString meetingID)
{
	bool ret;
	JMResult jmResult = (*mpfviewMeetingById)(meetingID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

bool IMeetingCalendarImpl::launchMeetingById(const PString meetingID)
{
	bool ret;
	JMResult jmResult = (*mpflaunchMeetingById)(meetingID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

void IMeetingCalendarImpl::invokeSystemTimeChange()
{
	JMResult jmResult = (*mpfinvokeSystemTimeChange)();
	assert(jmResult == JMSucceed);
}

bool IMeetingCalendarImpl::sendEmail(const PString tos, const PString subject, const PString body, const PString meetingID)
{
	bool ret;
	JMResult jmResult = (*mpfsendEmail)(tos, subject, body, meetingID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

void IMeetingCalendarImpl::receiveReminder(const PString sender, ReminderType remindType, const PString remindMsg)
{
	JMResult jmResult = (*mpfreceiveReminder)(sender, remindType, remindMsg);
	assert(jmResult == JMSucceed);
}

PString IMeetingCalendarImpl::getRemindCommandMessage(const PString meetingID)
{
	PString ret;
	JMResult jmResult = (*mpfgetRemindCommandMessage)(meetingID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

PString IMeetingCalendarImpl::getInviteCommandMessage(const PString meetingID)
{
	PString ret;
	JMResult jmResult = (*mpfgetInviteCommandMessage)(meetingID, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

void IMeetingCalendarImpl::getCMRInfo(const PString cmrInfo)
{
	JMResult jmResult = (*mpfgetCMRInfo)(cmrInfo);
	assert(jmResult == JMSucceed);
}


/***
*	IWbxMeetingAccountQueryImpl
***/
IWbxMeetingAccountQueryImpl::IWbxMeetingAccountQueryImpl()
{
	mpfregisterQueryEvent = NULL;
	mpfunregisterQueryEvent = NULL;
	mpfisExistAccount = NULL;
	mpfgetAccountProperty = NULL;
	mpfgetSiteProperty = NULL;
	mpfgetAccountName = NULL;
}

IWbxMeetingAccountQueryImpl::~IWbxMeetingAccountQueryImpl()
{
}

void IWbxMeetingAccountQueryImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountQuery_registerQueryEvent, (void**)&mpfregisterQueryEvent);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountQuery_unregisterQueryEvent, (void**)&mpfunregisterQueryEvent);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountQuery_isExistAccount, (void**)&mpfisExistAccount);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountQuery_getAccountProperty, (void**)&mpfgetAccountProperty);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountQuery_getSiteProperty, (void**)&mpfgetSiteProperty);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountQuery_getAccountName, (void**)&mpfgetAccountName);
}

void IWbxMeetingAccountQueryImpl::FuncUnInit()
{
	mpfregisterQueryEvent = NULL;
	mpfunregisterQueryEvent = NULL;
	mpfisExistAccount = NULL;
	mpfgetAccountProperty = NULL;
	mpfgetSiteProperty = NULL;
	mpfgetAccountName = NULL;
}

void IWbxMeetingAccountQueryImpl::registerQueryEvent(IWbxMeetingAccountEvent* pEvent)
{
	JMResult jmResult = (*mpfregisterQueryEvent)(pEvent);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountQueryImpl::unregisterQueryEvent(IWbxMeetingAccountEvent* pEvent)
{
	JMResult jmResult = (*mpfunregisterQueryEvent)(pEvent);
	assert(jmResult == JMSucceed);
}

bool IWbxMeetingAccountQueryImpl::isExistAccount()
{
	bool ret;
	JMResult jmResult = (*mpfisExistAccount)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

WbxMeetingAccountProperty IWbxMeetingAccountQueryImpl::getAccountProperty()
{
	WbxMeetingAccountProperty ret;
	JMResult jmResult = (*mpfgetAccountProperty)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

WbxMeetingSiteProperty IWbxMeetingAccountQueryImpl::getSiteProperty()
{
	WbxMeetingSiteProperty ret;
	JMResult jmResult = (*mpfgetSiteProperty)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}

PString IWbxMeetingAccountQueryImpl::getAccountName()
{
	PString ret;
	JMResult jmResult = (*mpfgetAccountName)(ret);
	assert(jmResult == JMSucceed);
	return ret;
}


/***
*	IWbxMeetingAccountOperatorImpl
***/
IWbxMeetingAccountOperatorImpl::IWbxMeetingAccountOperatorImpl()
{
	mpfclearAccount = NULL;
	mpfresetAccount = NULL;
	mpfrefreshSessionTicket = NULL;
	mpfopenOneClickSetting = NULL;
}

IWbxMeetingAccountOperatorImpl::~IWbxMeetingAccountOperatorImpl()
{
}

void IWbxMeetingAccountOperatorImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountOperator_clearAccount, (void**)&mpfclearAccount);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountOperator_resetAccount, (void**)&mpfresetAccount);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountOperator_refreshSessionTicket, (void**)&mpfrefreshSessionTicket);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountOperator_openOneClickSetting, (void**)&mpfopenOneClickSetting);
}

void IWbxMeetingAccountOperatorImpl::FuncUnInit()
{
	mpfclearAccount = NULL;
	mpfresetAccount = NULL;
	mpfrefreshSessionTicket = NULL;
	mpfopenOneClickSetting = NULL;
}

void IWbxMeetingAccountOperatorImpl::clearAccount()
{
	JMResult jmResult = (*mpfclearAccount)();
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountOperatorImpl::resetAccount(const WbxMeetingAccountProperty& accountProperty, const WbxMeetingSiteProperty& siteProperty)
{
	JMResult jmResult = (*mpfresetAccount)(accountProperty, siteProperty);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountOperatorImpl::refreshSessionTicket(const PString sessionTicket)
{
	JMResult jmResult = (*mpfrefreshSessionTicket)(sessionTicket);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountOperatorImpl::openOneClickSetting()
{
	JMResult jmResult = (*mpfopenOneClickSetting)();
	assert(jmResult == JMSucceed);
}


/***
*	IWbxMeetingAccountValidationImpl
***/
IWbxMeetingAccountValidationImpl::IWbxMeetingAccountValidationImpl()
{
	mpfsetValidationEvent = NULL;
	mpfgetSiteSSOInfo = NULL;
	mpfcheckSiteListSSOInfo = NULL;
	mpfcheckSiteSSOInfo = NULL;
	mpfverifyAccount = NULL;
}

IWbxMeetingAccountValidationImpl::~IWbxMeetingAccountValidationImpl()
{
}

void IWbxMeetingAccountValidationImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountValidation_setValidationEvent, (void**)&mpfsetValidationEvent);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountValidation_getSiteSSOInfo, (void**)&mpfgetSiteSSOInfo);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountValidation_checkSiteListSSOInfo, (void**)&mpfcheckSiteListSSOInfo);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountValidation_checkSiteSSOInfo, (void**)&mpfcheckSiteSSOInfo);
	jmResult = (*pfFunctionGet)(JMSDK_IWbxMeetingAccountValidation_verifyAccount, (void**)&mpfverifyAccount);
}

void IWbxMeetingAccountValidationImpl::FuncUnInit()
{
	mpfsetValidationEvent = NULL;
	mpfgetSiteSSOInfo = NULL;
	mpfcheckSiteListSSOInfo = NULL;
	mpfcheckSiteSSOInfo = NULL;
	mpfverifyAccount = NULL;
}

void IWbxMeetingAccountValidationImpl::setValidationEvent(IWbxMeetingAccountValidationEvent* pEvent)
{
	JMResult jmResult = (*mpfsetValidationEvent)(pEvent);
	assert(jmResult == JMSucceed);
}

CHECK_SITE_SSO_RESULT IWbxMeetingAccountValidationImpl::getSiteSSOInfo(const PString url)
{
	CHECK_SITE_SSO_RESULT ret;
	JMResult jmResult = (*mpfgetSiteSSOInfo)(url, ret);
	assert(jmResult == JMSucceed);
	return ret;
}

void IWbxMeetingAccountValidationImpl::checkSiteListSSOInfo(const PString siteList)
{
	JMResult jmResult = (*mpfcheckSiteListSSOInfo)(siteList);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountValidationImpl::checkSiteSSOInfo(const PString url)
{
	JMResult jmResult = (*mpfcheckSiteSSOInfo)(url);
	assert(jmResult == JMSucceed);
}

void IWbxMeetingAccountValidationImpl::verifyAccount(const PString siteURL, const PString userName, const PString userCred, bool isSSO)
{
	JMResult jmResult = (*mpfverifyAccount)(siteURL, userName, userCred, isSSO);
	assert(jmResult == JMSucceed);
}


/***
*	IJMSDKInstanceImpl
***/
IJMSDKInstanceImpl::IJMSDKInstanceImpl()
{
	mpfcreateJMSDK = NULL;
	mpfdeleteJMSDK = NULL;
	mpfstartJMSDK = NULL;
	mpfstopJMSDK = NULL;
	mpfChangeCapability = NULL;
}

IJMSDKInstanceImpl::~IJMSDKInstanceImpl()
{
}

void IJMSDKInstanceImpl::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmsdk_function_get");
	assert(pFunc != NULL);
	PFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;

	JMResult jmResult;
	jmResult = (*pfFunctionGet)(JMSDK_IJMSDKInstance_createJMSDK, (void**)&mpfcreateJMSDK);
	jmResult = (*pfFunctionGet)(JMSDK_IJMSDKInstance_deleteJMSDK, (void**)&mpfdeleteJMSDK);
	jmResult = (*pfFunctionGet)(JMSDK_IJMSDKInstance_startJMSDK, (void**)&mpfstartJMSDK);
	jmResult = (*pfFunctionGet)(JMSDK_IJMSDKInstance_stopJMSDK, (void**)&mpfstopJMSDK);
	jmResult = (*pfFunctionGet)(JMSDK_IJMSDKInstance_ChangeCapability, (void**)&mpfChangeCapability);
}

void IJMSDKInstanceImpl::FuncUnInit()
{
	mpfcreateJMSDK = NULL;
	mpfdeleteJMSDK = NULL;
	mpfstartJMSDK = NULL;
	mpfstopJMSDK = NULL;
	mpfChangeCapability = NULL;
}

void IJMSDKInstanceImpl::createJMSDK(bool isDesktopShareEnable, bool isMeetingAccountEnable, bool isInstantMeetingEnable, bool isMeetingListEnable)
{
	JMResult jmResult = (*mpfcreateJMSDK)(isDesktopShareEnable, isMeetingAccountEnable, isInstantMeetingEnable, isMeetingListEnable);
	assert(jmResult == JMSucceed);
}

void IJMSDKInstanceImpl::deleteJMSDK()
{
	JMResult jmResult = (*mpfdeleteJMSDK)();
	assert(jmResult == JMSucceed);
}

void IJMSDKInstanceImpl::startJMSDK()
{
	JMResult jmResult = (*mpfstartJMSDK)();
	assert(jmResult == JMSucceed);
}

void IJMSDKInstanceImpl::stopJMSDK()
{
	JMResult jmResult = (*mpfstopJMSDK)();
	assert(jmResult == JMSucceed);
}

void IJMSDKInstanceImpl::ChangeCapability(bool isDesktopShareEnable, bool isMeetingAccountEnable, bool isInstantMeetingEnable, bool isMeetingListEnable)
{
	JMResult jmResult = (*mpfChangeCapability)(isDesktopShareEnable, isMeetingAccountEnable, isInstantMeetingEnable, isMeetingListEnable);
	assert(jmResult == JMSucceed);
}


/***
*	IJabberMeetingSDKDelegateWrapper
***/
IJabberMeetingSDKDelegate* IJabberMeetingSDKDelegateWrapper::m_pIJabberMeetingSDKDelegate = NULL;
void IJabberMeetingSDKDelegateWrapper::SetHandler(IJabberMeetingSDKDelegate* pIJabberMeetingSDKDelegate)
{
	m_pIJabberMeetingSDKDelegate = pIJabberMeetingSDKDelegate;
}

void IJabberMeetingSDKDelegateWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_sendInstantMeetingInvitation, (void*)&IJabberMeetingSDKDelegateWrapper::sendInstantMeetingInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_sendInstantMeetingCancelInvitation, (void*)&IJabberMeetingSDKDelegateWrapper::sendInstantMeetingCancelInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_sendInstantMeetingDecline, (void*)&IJabberMeetingSDKDelegateWrapper::sendInstantMeetingDecline);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_sendDesktopSharingInvitation, (void*)&IJabberMeetingSDKDelegateWrapper::sendDesktopSharingInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_sendDesktopSharingCancelInvitation, (void*)&IJabberMeetingSDKDelegateWrapper::sendDesktopSharingCancelInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_sendDesktopSharingDecline, (void*)&IJabberMeetingSDKDelegateWrapper::sendDesktopSharingDecline);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_getAttendeeEmail, (void*)&IJabberMeetingSDKDelegateWrapper::getAttendeeEmail);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_getAttendeeDispalyName, (void*)&IJabberMeetingSDKDelegateWrapper::getAttendeeDispalyName);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_hideChatWindow, (void*)&IJabberMeetingSDKDelegateWrapper::hideChatWindow);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_showChatWindow, (void*)&IJabberMeetingSDKDelegateWrapper::showChatWindow);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_onUserTryLeave, (void*)&IJabberMeetingSDKDelegateWrapper::onUserTryLeave);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_getJabberAccountName, (void*)&IJabberMeetingSDKDelegateWrapper::getJabberAccountName);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_getJabberAccountNameFromEmail, (void*)&IJabberMeetingSDKDelegateWrapper::getJabberAccountNameFromEmail);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_addInMeetingPresence, (void*)&IJabberMeetingSDKDelegateWrapper::addInMeetingPresence);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_removeInMeetingPresence, (void*)&IJabberMeetingSDKDelegateWrapper::removeInMeetingPresence);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_addInWebExMeetingPresence, (void*)&IJabberMeetingSDKDelegateWrapper::addInWebExMeetingPresence);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_removeInWebExMeetingPresence, (void*)&IJabberMeetingSDKDelegateWrapper::removeInWebExMeetingPresence);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_addInWebExSharingPresence, (void*)&IJabberMeetingSDKDelegateWrapper::addInWebExSharingPresence);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_removeInWebExSharingPresence, (void*)&IJabberMeetingSDKDelegateWrapper::removeInWebExSharingPresence);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_addInDesktopSharingPresence, (void*)&IJabberMeetingSDKDelegateWrapper::addInDesktopSharingPresence);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_removeInDesktopSharingPresence, (void*)&IJabberMeetingSDKDelegateWrapper::removeInDesktopSharingPresence);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_addSharingInDesktopSharingPresence, (void*)&IJabberMeetingSDKDelegateWrapper::addSharingInDesktopSharingPresence);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_removeShareingInDesktopSharingPresence, (void*)&IJabberMeetingSDKDelegateWrapper::removeShareingInDesktopSharingPresence);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_isAccount, (void*)&IJabberMeetingSDKDelegateWrapper::isAccount);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_IsDSPolicyEnable, (void*)&IJabberMeetingSDKDelegateWrapper::IsDSPolicyEnable);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_hasDSCapability, (void*)&IJabberMeetingSDKDelegateWrapper::hasDSCapability);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_hasIMCapability, (void*)&IJabberMeetingSDKDelegateWrapper::hasIMCapability);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_isBuddyOnline, (void*)&IJabberMeetingSDKDelegateWrapper::isBuddyOnline);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_isCupModel, (void*)&IJabberMeetingSDKDelegateWrapper::isCupModel);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_isWbxMeetingEnabled, (void*)&IJabberMeetingSDKDelegateWrapper::isWbxMeetingEnabled);
	jmResult = (*pfEventCallbackSet)(JMSDK_IJabberMeetingSDKDelegate_sendMeetingReminder, (void*)&IJabberMeetingSDKDelegateWrapper::sendMeetingReminder);
}

void IJabberMeetingSDKDelegateWrapper::sendInstantMeetingInvitation(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->sendInstantMeetingInvitation(buddyName, cmdMsg, htmlMsg, plantMsg);
	}
}

void IJabberMeetingSDKDelegateWrapper::sendInstantMeetingCancelInvitation(const PString buddyName)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->sendInstantMeetingCancelInvitation(buddyName);
	}
}

void IJabberMeetingSDKDelegateWrapper::sendInstantMeetingDecline(const PString buddyName)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->sendInstantMeetingDecline(buddyName);
	}
}

void IJabberMeetingSDKDelegateWrapper::sendDesktopSharingInvitation(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->sendDesktopSharingInvitation(buddyName, cmdMsg, htmlMsg, plantMsg);
	}
}

void IJabberMeetingSDKDelegateWrapper::sendDesktopSharingCancelInvitation(const PString buddyName)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->sendDesktopSharingCancelInvitation(buddyName);
	}
}

void IJabberMeetingSDKDelegateWrapper::sendDesktopSharingDecline(const PString buddyName)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->sendDesktopSharingDecline(buddyName);
	}
}

void IJabberMeetingSDKDelegateWrapper::getAttendeeEmail(const PString attendeeJID, PString& attendeeEmail)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->getAttendeeEmail(attendeeJID, attendeeEmail);
	}
}

void IJabberMeetingSDKDelegateWrapper::getAttendeeDispalyName(const PString attendeeJID, PString& attendeeDN)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->getAttendeeDispalyName(attendeeJID, attendeeDN);
	}
}

void IJabberMeetingSDKDelegateWrapper::hideChatWindow()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->hideChatWindow();
	}
}

void IJabberMeetingSDKDelegateWrapper::showChatWindow()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->showChatWindow();
	}
}

void IJabberMeetingSDKDelegateWrapper::onUserTryLeave(bool isHost)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->onUserTryLeave(isHost);
	}
}

PString IJabberMeetingSDKDelegateWrapper::getJabberAccountName()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		return m_pIJabberMeetingSDKDelegate->getJabberAccountName();
	}
	return "";
}

PString IJabberMeetingSDKDelegateWrapper::getJabberAccountNameFromEmail(const PString email)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		return m_pIJabberMeetingSDKDelegate->getJabberAccountNameFromEmail(email);
	}
	return "";
}

void IJabberMeetingSDKDelegateWrapper::addInMeetingPresence()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->addInMeetingPresence();
	}
}

void IJabberMeetingSDKDelegateWrapper::removeInMeetingPresence()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->removeInMeetingPresence();
	}
}

void IJabberMeetingSDKDelegateWrapper::addInWebExMeetingPresence()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->addInWebExMeetingPresence();
	}
}

void IJabberMeetingSDKDelegateWrapper::removeInWebExMeetingPresence()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->removeInWebExMeetingPresence();
	}
}

void IJabberMeetingSDKDelegateWrapper::addInWebExSharingPresence()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->addInWebExSharingPresence();
	}
}

void IJabberMeetingSDKDelegateWrapper::removeInWebExSharingPresence()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->removeInWebExSharingPresence();
	}
}

void IJabberMeetingSDKDelegateWrapper::addInDesktopSharingPresence()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->addInDesktopSharingPresence();
	}
}

void IJabberMeetingSDKDelegateWrapper::removeInDesktopSharingPresence()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->removeInDesktopSharingPresence();
	}
}

void IJabberMeetingSDKDelegateWrapper::addSharingInDesktopSharingPresence()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->addSharingInDesktopSharingPresence();
	}
}

void IJabberMeetingSDKDelegateWrapper::removeShareingInDesktopSharingPresence()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->removeShareingInDesktopSharingPresence();
	}
}

bool IJabberMeetingSDKDelegateWrapper::isAccount(const PString & sessionName)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		return m_pIJabberMeetingSDKDelegate->isAccount(sessionName);
	}
	return false;
}

bool IJabberMeetingSDKDelegateWrapper::IsDSPolicyEnable(const PString & sessionName, int & nPolicyResult)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		return m_pIJabberMeetingSDKDelegate->IsDSPolicyEnable(sessionName, nPolicyResult);
	}
	return false;
}

bool IJabberMeetingSDKDelegateWrapper::hasDSCapability(const PString & sessionName)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		return m_pIJabberMeetingSDKDelegate->hasDSCapability(sessionName);
	}
	return false;
}

bool IJabberMeetingSDKDelegateWrapper::hasIMCapability(const PString & sessionName)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		return m_pIJabberMeetingSDKDelegate->hasIMCapability(sessionName);
	}
	return false;
}

bool IJabberMeetingSDKDelegateWrapper::isBuddyOnline(const PString & sessionName)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		return m_pIJabberMeetingSDKDelegate->isBuddyOnline(sessionName);
	}
	return false;
}

bool IJabberMeetingSDKDelegateWrapper::isCupModel()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		return m_pIJabberMeetingSDKDelegate->isCupModel();
	}
	return false;
}

bool IJabberMeetingSDKDelegateWrapper::isWbxMeetingEnabled()
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		return m_pIJabberMeetingSDKDelegate->isWbxMeetingEnabled();
	}
	return false;
}

void IJabberMeetingSDKDelegateWrapper::sendMeetingReminder(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg)
{
	if(m_pIJabberMeetingSDKDelegate != NULL)
	{
		m_pIJabberMeetingSDKDelegate->sendMeetingReminder(buddyName, cmdMsg, htmlMsg, plantMsg);
	}
}


/***
*	IJMLoggerWrapper
***/
IJMLogger* IJMLoggerWrapper::m_pIJMLogger = NULL;
void IJMLoggerWrapper::SetHandler(IJMLogger* pIJMLogger)
{
	m_pIJMLogger = pIJMLogger;
}

void IJMLoggerWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_IJMLogger_log, (void*)&IJMLoggerWrapper::log);
}

void IJMLoggerWrapper::log(int level, const char *sourceFile, int sourceLine, const char *function, const char *fmt, va_list args)
{
	if(m_pIJMLogger != NULL)
	{
		m_pIJMLogger->log(level, sourceFile, sourceLine, function, fmt, args);
	}
}


/***
*	IMeetingCalendarEventWrapper
***/
IMeetingCalendarEvent* IMeetingCalendarEventWrapper::m_pIMeetingCalendarEvent = NULL;
void IMeetingCalendarEventWrapper::SetHandler(IMeetingCalendarEvent* pIMeetingCalendarEvent)
{
	m_pIMeetingCalendarEvent = pIMeetingCalendarEvent;
}

void IMeetingCalendarEventWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onCalendarEnabled, (void*)&IMeetingCalendarEventWrapper::onCalendarEnabled);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingEnabled, (void*)&IMeetingCalendarEventWrapper::onMeetingEnabled);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingListed, (void*)&IMeetingCalendarEventWrapper::onMeetingListed);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onGetMeetingDetail, (void*)&IMeetingCalendarEventWrapper::onGetMeetingDetail);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingOvernight, (void*)&IMeetingCalendarEventWrapper::onMeetingOvernight);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingReminderHappened, (void*)&IMeetingCalendarEventWrapper::onMeetingReminderHappened);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingReminderUpdated, (void*)&IMeetingCalendarEventWrapper::onMeetingReminderUpdated);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingReminderEnded, (void*)&IMeetingCalendarEventWrapper::onMeetingReminderEnded);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingStarted, (void*)&IMeetingCalendarEventWrapper::onMeetingStarted);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingEnded, (void*)&IMeetingCalendarEventWrapper::onMeetingEnded);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingError, (void*)&IMeetingCalendarEventWrapper::onMeetingError);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingInvitationReceived, (void*)&IMeetingCalendarEventWrapper::onMeetingInvitationReceived);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingInvitationCanceled, (void*)&IMeetingCalendarEventWrapper::onMeetingInvitationCanceled);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onMeetingDeclined, (void*)&IMeetingCalendarEventWrapper::onMeetingDeclined);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onPopupMeetingWaitDialog, (void*)&IMeetingCalendarEventWrapper::onPopupMeetingWaitDialog);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onCloseMeetingWaitDialog, (void*)&IMeetingCalendarEventWrapper::onCloseMeetingWaitDialog);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onCmrMeetingStarted, (void*)&IMeetingCalendarEventWrapper::onCmrMeetingStarted);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onCmrMeetingJoined, (void*)&IMeetingCalendarEventWrapper::onCmrMeetingJoined);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onCmrMeetingEnded, (void*)&IMeetingCalendarEventWrapper::onCmrMeetingEnded);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onCmrMeetingError, (void*)&IMeetingCalendarEventWrapper::onCmrMeetingError);
	jmResult = (*pfEventCallbackSet)(JMSDK_IMeetingCalendarEvent_onCmrInfo, (void*)&IMeetingCalendarEventWrapper::onCmrInfo);
}

void IMeetingCalendarEventWrapper::onCalendarEnabled(bool bEnable)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onCalendarEnabled(bEnable);
	}
}

void IMeetingCalendarEventWrapper::onMeetingEnabled(bool bEnable)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingEnabled(bEnable);
	}
}

void IMeetingCalendarEventWrapper::onMeetingListed(MeetingCalendarErrorCode errCode)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingListed(errCode);
	}
}

void IMeetingCalendarEventWrapper::onGetMeetingDetail(const MeetingData& meeting)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onGetMeetingDetail(meeting);
	}
}

void IMeetingCalendarEventWrapper::onMeetingOvernight()
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingOvernight();
	}
}

void IMeetingCalendarEventWrapper::onMeetingReminderHappened(const ReminderInfo& reminder)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingReminderHappened(reminder);
	}
}

void IMeetingCalendarEventWrapper::onMeetingReminderUpdated(const ReminderInfo& reminder)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingReminderUpdated(reminder);
	}
}

void IMeetingCalendarEventWrapper::onMeetingReminderEnded(const PString meetingID)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingReminderEnded(meetingID);
	}
}

void IMeetingCalendarEventWrapper::onMeetingStarted(const PString sessionName, const PString meetingID, bool host)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingStarted(sessionName, meetingID, host);
	}
}

void IMeetingCalendarEventWrapper::onMeetingEnded(const PString sessionName, const PString meetingID)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingEnded(sessionName, meetingID);
	}
}

void IMeetingCalendarEventWrapper::onMeetingError(const PString sessionName, const PString meetingID, int errCode)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingError(sessionName, meetingID, errCode);
	}
}

void IMeetingCalendarEventWrapper::onMeetingInvitationReceived(const PString sessionName, const PString meetingTopic)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingInvitationReceived(sessionName, meetingTopic);
	}
}

void IMeetingCalendarEventWrapper::onMeetingInvitationCanceled(const PString sessionName)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingInvitationCanceled(sessionName);
	}
}

void IMeetingCalendarEventWrapper::onMeetingDeclined(const PString sessionName, const PString buddyName)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onMeetingDeclined(sessionName, buddyName);
	}
}

void IMeetingCalendarEventWrapper::onPopupMeetingWaitDialog()
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onPopupMeetingWaitDialog();
	}
}

void IMeetingCalendarEventWrapper::onCloseMeetingWaitDialog()
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onCloseMeetingWaitDialog();
	}
}

void IMeetingCalendarEventWrapper::onCmrMeetingStarted(const JM_SDK::CmrMeetingData & meetingInfo)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onCmrMeetingStarted(meetingInfo);
	}
}

void IMeetingCalendarEventWrapper::onCmrMeetingJoined()
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onCmrMeetingJoined();
	}
}

void IMeetingCalendarEventWrapper::onCmrMeetingEnded()
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onCmrMeetingEnded();
	}
}

void IMeetingCalendarEventWrapper::onCmrMeetingError(JM_SDK::INSTANT_MEETING_ERROR_CODE errorCode)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onCmrMeetingError(errorCode);
	}
}

void IMeetingCalendarEventWrapper::onCmrInfo(const PString cmrInfo)
{
	if(m_pIMeetingCalendarEvent != NULL)
	{
		m_pIMeetingCalendarEvent->onCmrInfo(cmrInfo);
	}
}


/***
*	IWbxMeetingAccountValidationEventWrapper
***/
IWbxMeetingAccountValidationEvent* IWbxMeetingAccountValidationEventWrapper::m_pIWbxMeetingAccountValidationEvent = NULL;
void IWbxMeetingAccountValidationEventWrapper::SetHandler(IWbxMeetingAccountValidationEvent* pIWbxMeetingAccountValidationEvent)
{
	m_pIWbxMeetingAccountValidationEvent = pIWbxMeetingAccountValidationEvent;
}

void IWbxMeetingAccountValidationEventWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_IWbxMeetingAccountValidationEvent_onCheckSiteListSSOInfo, (void*)&IWbxMeetingAccountValidationEventWrapper::onCheckSiteListSSOInfo);
	jmResult = (*pfEventCallbackSet)(JMSDK_IWbxMeetingAccountValidationEvent_onCheckSiteSSOInfo, (void*)&IWbxMeetingAccountValidationEventWrapper::onCheckSiteSSOInfo);
	jmResult = (*pfEventCallbackSet)(JMSDK_IWbxMeetingAccountValidationEvent_onVerifyAccount, (void*)&IWbxMeetingAccountValidationEventWrapper::onVerifyAccount);
}

void IWbxMeetingAccountValidationEventWrapper::onCheckSiteListSSOInfo()
{
	if(m_pIWbxMeetingAccountValidationEvent != NULL)
	{
		m_pIWbxMeetingAccountValidationEvent->onCheckSiteListSSOInfo();
	}
}

void IWbxMeetingAccountValidationEventWrapper::onCheckSiteSSOInfo(WBX_MEETING_ACCOUNT_ERROR errorCode, const PString url, CHECK_SITE_SSO_RESULT result)
{
	if(m_pIWbxMeetingAccountValidationEvent != NULL)
	{
		m_pIWbxMeetingAccountValidationEvent->onCheckSiteSSOInfo(errorCode, url, result);
	}
}

void IWbxMeetingAccountValidationEventWrapper::onVerifyAccount(WBX_MEETING_ACCOUNT_ERROR result, const WbxMeetingAccountProperty& accountProperty, const WbxMeetingSiteProperty& siteProperty)
{
	if(m_pIWbxMeetingAccountValidationEvent != NULL)
	{
		m_pIWbxMeetingAccountValidationEvent->onVerifyAccount(result, accountProperty, siteProperty);
	}
}


/***
*	IDSEventWrapper
***/
IDSEvent* IDSEventWrapper::m_pIDSEvent = NULL;
void IDSEventWrapper::SetHandler(IDSEvent* pIDSEvent)
{
	m_pIDSEvent = pIDSEvent;
}

void IDSEventWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onPopupDSWaitingDialog, (void*)&IDSEventWrapper::onPopupDSWaitingDialog);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onCloseDSWaitingDialog, (void*)&IDSEventWrapper::onCloseDSWaitingDialog);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onDSStarted, (void*)&IDSEventWrapper::onDSStarted);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onDSEnded, (void*)&IDSEventWrapper::onDSEnded);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onDSError, (void*)&IDSEventWrapper::onDSError);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onPopupChatWindow, (void*)&IDSEventWrapper::onPopupChatWindow);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onMinimizeChatWindow, (void*)&IDSEventWrapper::onMinimizeChatWindow);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onDSInvitation, (void*)&IDSEventWrapper::onDSInvitation);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onDSDeclined, (void*)&IDSEventWrapper::onDSDeclined);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onDSCancelled, (void*)&IDSEventWrapper::onDSCancelled);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onSharingStopped, (void*)&IDSEventWrapper::onSharingStopped);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onBuddyJoined, (void*)&IDSEventWrapper::onBuddyJoined);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onUserTryLeave, (void*)&IDSEventWrapper::onUserTryLeave);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onUserLeft, (void*)&IDSEventWrapper::onUserLeft);
	jmResult = (*pfEventCallbackSet)(JMSDK_IDSEvent_onPresenterChanged, (void*)&IDSEventWrapper::onPresenterChanged);
}

void IDSEventWrapper::onPopupDSWaitingDialog()
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onPopupDSWaitingDialog();
	}
}

void IDSEventWrapper::onCloseDSWaitingDialog()
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onCloseDSWaitingDialog();
	}
}

void IDSEventWrapper::onDSStarted(const PString sessionName, bool isHost)
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onDSStarted(sessionName, isHost);
	}
}

void IDSEventWrapper::onDSEnded(const PString sessionName, bool isHost)
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onDSEnded(sessionName, isHost);
	}
}

void IDSEventWrapper::onDSError(const DS_ERROR_CODE errorCode, const PString sessionName)
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onDSError(errorCode, sessionName);
	}
}

void IDSEventWrapper::onPopupChatWindow(const PString sessionName)
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onPopupChatWindow(sessionName);
	}
}

void IDSEventWrapper::onMinimizeChatWindow(const PString sessionName)
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onMinimizeChatWindow(sessionName);
	}
}

void IDSEventWrapper::onDSInvitation(const PString sessionName)
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onDSInvitation(sessionName);
	}
}

void IDSEventWrapper::onDSDeclined(const PString sessionName)
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onDSDeclined(sessionName);
	}
}

void IDSEventWrapper::onDSCancelled(const PString sessionName)
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onDSCancelled(sessionName);
	}
}

void IDSEventWrapper::onSharingStopped(const PString sessionName)
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onSharingStopped(sessionName);
	}
}

void IDSEventWrapper::onBuddyJoined()
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onBuddyJoined();
	}
}

void IDSEventWrapper::onUserTryLeave(bool isHost)
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onUserTryLeave(isHost);
	}
}

void IDSEventWrapper::onUserLeft()
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onUserLeft();
	}
}

void IDSEventWrapper::onPresenterChanged()
{
	if(m_pIDSEvent != NULL)
	{
		m_pIDSEvent->onPresenterChanged();
	}
}


/***
*	INetworkTransportWrapper
***/
INetworkTransport* INetworkTransportWrapper::m_pINetworkTransport = NULL;
void INetworkTransportWrapper::SetHandler(INetworkTransport* pINetworkTransport)
{
	m_pINetworkTransport = pINetworkTransport;
}

void INetworkTransportWrapper::FuncInit(JMHandle libHandle)
{
	assert(libHandle != 0);

	void *pFunc = (void*)dlsym(libHandle, "jmevent_callback_set");
	assert(pFunc != NULL);
	PFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;

	JMResult jmResult;
	jmResult = (*pfEventCallbackSet)(JMSDK_INetworkTransport_HttpRequest, (void*)&INetworkTransportWrapper::HttpRequest);
	jmResult = (*pfEventCallbackSet)(JMSDK_INetworkTransport_HttpRequestAsync, (void*)&INetworkTransportWrapper::HttpRequestAsync);
	jmResult = (*pfEventCallbackSet)(JMSDK_INetworkTransport_Registered, (void*)&INetworkTransportWrapper::Registered);
}

void INetworkTransportWrapper::HttpRequest(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc)
{
	if(m_pINetworkTransport != NULL)
	{
		m_pINetworkTransport->HttpRequest(httpUrl, httpHeader, httpPostData, httpMethod, successProc, errorProc);
	}
}

void INetworkTransportWrapper::HttpRequestAsync(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc)
{
	if(m_pINetworkTransport != NULL)
	{
		m_pINetworkTransport->HttpRequestAsync(httpUrl, httpHeader, httpPostData, httpMethod, successProc, errorProc);
	}
}

bool INetworkTransportWrapper::Registered()
{
	if(m_pINetworkTransport != NULL)
	{
		return m_pINetworkTransport->Registered();
	}
	return false;
}

